<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('subscription_statuses', function (Blueprint $table) {
            $table->foreign('created_by')->references('id')->on('users')->onUpdate('CASCADE');
            $table->foreign('updated_by')->references('id')->on('users')->onUpdate('CASCADE');
            $table->foreign('deleted_by')->references('id')->on('users')->onUpdate('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('subscription_statuses', function (Blueprint $table) {
            $table->dropForeign('created_by');
            $table->dropForeign('updated_by');
            $table->dropForeign('deleted_by');
        });
    }
};
