<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Model;

/**
 * @property integer $id
 * @property string $name
 * @property integer $is_active
 * @property string $created_at
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $updated_at
 * @property integer $is_deleted
 * @property string $deleted_at
 * @property integer $deleted_by
 * @property UsersRole[] $usersRoles
 */
class Role extends Model
{
    /**
     * The "type" of the auto-incrementing ID.
     * 
     * @var string
     */
    protected $keyType = 'integer';

    /**
     * @var array
     */
    protected $fillable = ['name', 'is_active', 'created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];
    protected $hidden = ['created_at', 'created_by', 'updated_by', 'updated_at', 'is_deleted', 'deleted_at', 'deleted_by'];

    /**
     * Scope Active
     */
    public function scopeActive($query)
    {
        return $query->where('roles.is_active', '1');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function usersRoles()
    {
        return $this->hasMany('App\Models\api\v1\UsersRole');
    }
}
