<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QrcodeTable extends Model
{
    use HasFactory;

    public $table = "qrcode_tables";

    protected $fillable = [
        'num_carte',
        'titre',
        'sous_titre',
        'couleur',
        'status',
        'qr_code',
        'space_id',
        'table_num',
    ];

    public function cartes_tables_spaces()
    {
        return $this->belongsTo(Space::class, "space_id");
    }
}
