<?php

namespace App\Models\api\v1;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class QrCodeUsers extends Model
{
    use HasFactory;

    public $table = "qrcode_users";

    protected $fillable = [
        'num_carte',
        'titre',
        'sous_titre',
        'couleur',
        'status',
        'qr_code',
        'id_users'
    ];

    public function cartes_users()
    {
        return $this->belongsTo(User::class, "id_users");
    }
    
     public static function getQrCodeUser($userid){
        $qrcode = QrCodeUsers::where('id_users',$userid)->first();
        if($qrcode){
            $qrcode->qr_code  = asset($qrcode->qr_code);
        }
        return $qrcode;
    }
}
