<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\api\v1\MemberShip;
use App\Models\api\v1\Space;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class MembershipController extends Controller
{
    /**
     * barConnectWholesaler
     *
     * @param  mixed $request
     * @return JsonResponse
     */
    public function relationshipBarWholesaler(Request $request): JsonResponse
    {
        $validator = \Validator::make(
            $request->all(),
            [
                'space_uuid'    => 'required',
                'wholesaler_uuid'   => 'required',
            ]
        );
        if ($validator->fails()) {
            return $this->ReturnResponse(false, $validator->errors(), [], 400);
        }
        $space_uuid = $request->space_uuid;
        $wholesaler_uuid = $request->wholesaler_uuid;
        ///////get space data
        $space = Space::where('uuid', $space_uuid)->first();
        if (empty($space)) {
            return $this->ReturnResponse(false, "Space not found", [], 404);
        }
        //////get wholesaler data
        $saler = Space::where('uuid', $wholesaler_uuid)->first();
        if (empty($saler)) {
            return $this->ReturnResponse(false, "Wholesaler not found", [], 404);
        }
        $uuid = (string) \Str::uuid();
        $type = "bronz";
        if (!empty($request->type)) {
            $type = $request->type;
        }
        $data = array("uuid" => $uuid, "spaces_memberships_id" => $saler->id, "type" => $type, "space_id" => $space->id, "created_by" => $request->user()->id);
        MemberShip::create($data);
        return $this->ReturnResponse(true, "request registered successfully", [], 200);
    }

    /**
     * getRelationshipStatus
     *
     * @param  mixed $uuid
     * @return JsonResponse
     */
    public function getRelationshipStatus(string $uuid): JsonResponse
    {
        if (empty($uuid)) {
            return $this->ReturnResponse(false, "membersip required", [], 400);
        }
        /////get memebersip
        $relationship = MemberShip::where('uuid', $uuid)->first();
        if (empty($relationship)) {
            return $this->ReturnResponse(false, "relationship not found", [], 404);
        }
        return $this->ReturnResponse(true, "Status relationship", ["status" => $relationship->status], 200);
    }

    /**
     * getWholesalerRelationships
     *
     * @param  mixed $uuid
     * @return JsonResponse
     */
    public function getWholesalerRelationships(string $uuid, string $status = ''): JsonResponse
    {
        if (empty($uuid)) {
            return $this->ReturnResponse(false, "membersip required", [], 400);
        }
        ///////get wholesaler
        $space = Space::where('uuid', $uuid)->first();
        if (empty($space)) {
            return $this->ReturnResponse(false, "space not found", [], 404);
        }
        /////get membersip
        $relationships = MemberShip::where('spaces_memberships_id', $space->id);
        if (!empty($status)) {
            $relationships = $relationships->where('status', $status);
        }
        $relationships = $relationships->with('space')->get();
        return $this->ReturnResponse(true, "List of relationships", $relationships->toArray(), 200);
    }

    /**
     * acceptOrCancelRelationship
     *
     * @param  mixed $uuid
     * @param  mixed $status
     * @return JsonResponse
     */
    public function acceptOrCancelRelationship(string $uuid, string $status): JsonResponse
    {
        if (empty($uuid)) {
            return $this->ReturnResponse(false, "membersip required", [], 400);
        }
        if (empty($status)) {
            return $this->ReturnResponse(false, "status required", [], 400);
        }
        if ($status != "cancel" && $status != "accept") {
            return $this->ReturnResponse(false, "status is not correct", [], 400);
        }
        ///get membership 
        $relationship = MemberShip::where('uuid', $uuid)->first();
        if (empty($relationship)) {
            return $this->ReturnResponse(false, "Membership not found", [], 404);
        }
        $wholesalerStatus = "Canceled";
        if ($status == "accept") {
            $wholesalerStatus = "Accepted";
        }
        $relationship->status = $wholesalerStatus;
        $relationship->save();
        return $this->ReturnResponse(true, "update relationship", $relationship->toArray(), 200);
    }

    /**
     * getBarRelationships
     *
     * @param  mixed $uuid
     * @return JsonResponse
     */
    public function getBarRelationships(string $uuid, String $status = null): JsonResponse
    {
        if (empty($uuid)) {
            return $this->ReturnResponse(false, "membersip required", [], 400);
        }
        ///////get wholesaler
        $space = Space::where('uuid', $uuid)->first();
        if (empty($space)) {
            return $this->ReturnResponse(false, "space not found", [], 404);
        }
        /////get membersip
        $relationships = MemberShip::where('space_id', $space->id);
        if (!empty($status)) {
            $relationships = $relationships->where('status', $status);
        }
        $relationships = $relationships->with('wholesaler')->get();
        return $this->ReturnResponse(true, "List of relationships", $relationships->toArray(), 200);
    }
}
