<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\User;

class HostpostController extends Controller
{
    /***
     * Register Hotspot Manager
     */
    public function registerCustomer(Request $request)
    {
        if (empty($request->zone_name)) {
            return $this->ReturnResponse(false, "Champ Hostpot requis", [], 400);
        }
        if (empty($request->user_id)) {
            return $this->ReturnResponse(false, "Champ utilisateur requis", [], 400);
        }
        if (empty($request->subscription_name)) {
            return $this->ReturnResponse(false, "Offre requise", [], 400);
        }
        $user = User::where('uuid', $request->user_id)->first();
        if (empty($user)) {
            return $this->ReturnResponse(false, "Utilisateur Inconnu", [], 200);
        }
        $isOk = false;
        $checkCustomer = $this->checkCustomerExist($user->username, $request->zone_name, $isOk);
        if (!$isOk) {
            return $this->ReturnResponse(false, "Utilisateur ou Hostpot indisponible", [$checkCustomer], 200);
        }
        if (!empty($checkCustomer)) {
            return $this->ReturnResponse(false, "Utilisateur deja enregistré", [$checkCustomer], 403);
        }
        $data = array(
            "zone_name" => $request->zone_name,
            "subscription_name" => $request->subscription_name,
            "customer_firstname" => $user->username,
            "customer_lastname" => $user->username,
            "login_type"  => 2,
            "login_text"  => $user->username,
            "customer_password" => $user->username,
            "customer_mobile_number_code" => "00225",
            "customer_mobile_number" => $user->username,
            "customer_country" => "CI",
        );
        $url = env('HOTPOST_URL');
        $headers = array(
            "Content-Type: application/json"
        );
        $uri = $url . '/customer';
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPost($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 201) {
            return $this->ReturnResponse(false, "Impossible de créer l'utilisateur", [$result], $statusCode);
        }
        $result = json_decode($result);
        return $this->ReturnResponse(true, "Utilisateur crée avec succès", [$result], 200);
    }
    /***
     * Register Hotspot Manager
     */
    public function registerCustomerMother(array $data, &$isOk = false)
    {
        $isOk = false;
        if (empty($data['zone_name'])) {
            return "Champ Hostpot requis";
        }

        if (empty($data['subscription_name'])) {
            return "Offre requise";
        }
        if (empty($data['user_phone'])) {
            return "Numéro de telephone requis";
        }
        $isOk = false;
        $customer_email = $data['user_phone'] . "@motherafrica.com";
        $data = array(
            "zone_name" =>  $data['zone_name'],
            "subscription_name" => $data['subscription_name'],
            "customer_firstname" => $data['user_phone'],
            "customer_lastname" => $data['user_phone'],
            "customer_email"  => $customer_email,
            "customer_mobile_number" => $data['user_phone'],
            "customer_password" => $data['user_phone'],
        );
        $this->checkCustomerExist($customer_email, $data['zone_name'], $isOk);
        if ($isOk) {
            $isOk = true;
            return $data;
        }
        $url = env('HOTPOST_URL');
        // Encodage de l'authentification au format Base64
        $auth = base64_encode(env('HOTSPOT_USERNAME') . ":" . env('HOTSPOT_PWD'));

        $headers = array(
            "Authorization: Basic $auth",
            "Content-Type: application/json",
            "Accept: application/json"
        );
        $uri = $url . '/customer';
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPost($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 201) {
            $isOk = false;
            return "Impossible de créer l'utilisateur";
        }
        $result = json_decode($result);
        $isOk = true;
        return $data;
    }

    /**
     * login Hotspot
     */
    public function loginCustomer(Request $request)
    {
        if (empty($request->zone_name)) {
            return $this->ReturnResponse(false, "Champ Hostpot requis", [], 400);
        }
        if (empty($request->user_id)) {
            return $this->ReturnResponse(false, "Champ utilisateur requis", [], 400);
        }
        $user = User::where('uuid', $request->user_id)->first();
        if (empty($user)) {
            return $this->ReturnResponse(false, "Utilisateur Inconnu", [], 200);
        }
        $data = array(
            "zone_name" => $request->zone_name,
            "customer_login" => $user->username,
            "customer_password" => $user->username,
        );
        $url = env('HOTPOST_URL');
        $headers = array(
            "Content-Type: application/json"
        );
        $uri = $url . '/autologin/link';
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPost($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 200) {
            return $this->ReturnResponse(false, "Impossible de créer l'utilisateur", [$result], $statusCode);
        }
        $result = json_decode($result);
        return $this->ReturnResponse(true, "Utilisateur crée avec succès", [$result->autologin_link], 200);
    }

    /****
     * check if customer exist
     */
    public function checkCustomerExist($customer_login, $zone_name, &$isOk = false)
    {
        $isOk = false;
        $url = env('HOTPOST_URL');
        $auth = base64_encode(env('HOTSPOT_USERNAME') . ":" . env('HOTSPOT_PWD'));
        $headers = array(
            "Authorization: Basic $auth",
            "Content-Type: application/json",
            "Accept: application/json"
        );
        $statusCode = null;
        $params = [
            'zone_name' => $zone_name,
            'customer_login' => $customer_login
        ];
        $queryString = http_build_query($params);
        $uri = "$url/customer/refills?$queryString";
        $result = CommonService::wsGet($uri, $headers, $statusCode);
        if ($statusCode == 200) {
            $isOk = true;
        }
        return $result;
    }

    /******
     * Liste de tous les clients
     */
    public function getAllCustomers()
    {
        $isOk = false;
        $url = env('HOTPOST_URL');
        $headers = array(
            "Content-Type: application/json"
        );
        $statusCode = null;
        $uri = $url . '/customer';
        $result = CommonService::wsGet($uri, $headers, $statusCode);
        if ($statusCode != 200) {
            return $this->ReturnResponse(false, "Impossible de recuperer la liste des users", [$result], 200);
        }
        $result = json_encode($result);
        return $this->ReturnResponse(true, "Liste des utilisateurs", [$result], 200);
    }

    /****
     * Rechargement d'un client 
     */
    public function customeRefill(Request $request)
    {
        if (!isset($request->zone_name)) {
            return $this->ReturnResponse(false, "Champ Hotspot requis", [], 400);
        }
        if (!isset($request->user_id)) {
            return $this->ReturnResponse(false, "Champ Utilisateur requis", [], 400);
        }
        if (!isset($request->subscription_name)) {
            return $this->ReturnResponse(false, "Champ offre requis", [], 400);
        }
        $user = User::where('uuid', $request->user_id)->first();
        if (empty($user)) {
            return $this->ReturnResponse(false, "Utilisateur Inconnu", [], 200);
        }
        $url = env('HOTPOST_URL');
        $headers = array(
            "Content-Type: application/json"
        );
        $uri = $url . "/customer/refilling?zone_name=" . $request->zone_name . "&customer_login=" . $user->username;
        $data = array("subscription_name" => $request->subscription_name);
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPut($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 201) {
            return $this->ReturnResponse(false, "Impossible de recharger l'utilisateur", [$result], $statusCode);
        }
        $result = json_encode($result);
        return $this->ReturnResponse(true, "Utilisateur rechargé avec succès", [$result], 200);
    }

    /****
     * Rechargement d'un client 
     */
    public function customeRefillMother($data, &$isOk = false)
    {
        $isOk = false;
        if (empty($data['zone_name'])) {
            return "Champ Hotspot requis";
        }
        if (empty($data['phone'])) {
            return "Champ Utilisateur requis";
        }
        if (empty($data['subscription_name'])) {
            return "Champ offre requis";
        }

        $url = env('HOTPOST_URL');
        // Encodage de l'authentification au format Base64
        $auth = base64_encode(env('HOTSPOT_USERNAME') . ":" . env('HOTSPOT_PWD'));

        $headers = array(
            "Authorization: Basic $auth",
            "Content-Type: application/json",
            "Accept: application/json"
        );
        $params = [
            'zone_name' =>  $data['zone_name'],
            'customer_login' => $data['phone']
        ];
        $queryString = http_build_query($params);
        $uri = "$url/customer/refilling?$queryString";
        // $uri = $url . "/customer/refilling?zone_name=" . $data['zone_name'] . "&customer_login=" . $data['phone'];
        $data = array("subscription_name" => $data['subscription_name']);
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPut($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 200) {
            $isOk = false;
            return "Impossible de recharger l'utilisateur";
        }
        $result = json_encode($result);
        $isOk = true;
        return "Utilisateur rechargé avec succès";
    }

    /***
     * Creation d'une offre
     */
    public function subscription(Request $request)
    {
        if (!isset($request->zone_name)) {
            return $this->ReturnResponse(false, "Champ Hotspot requis", [], 400);
        }
        if (!isset($request->price)) {
            return $this->ReturnResponse(false, "Champ prix requis", [], 400);
        }
        if (!isset($request->validity)) {
            return $this->ReturnResponse(false, "Champ de validité de l'offre requis", [], 400);
        }
        if (!isset($request->subscription_name)) {
            return $this->ReturnResponse(false, "Champ offre requis", [], 400);
        }
        $data = array(
            "name" => $request->subscription_name,
            "price" => $request->price,
            "validity" => $request->validity,
        );
        $url = env('HOTPOST_URL');
        $headers = array(
            "Content-Type: application/json"
        );
        $uri = $url . '/subscription?zone_name=' . $request->zone_name;
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPost($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 200) {
            return $this->ReturnResponse(false, "Impossible de créer l'offre", [$result], $statusCode);
        }
        $result = json_encode($result);
        return $this->ReturnResponse(true, "Offfre créee avec succès", [$result], 200);
    }

    /***
     * Creer un coupon 
     */
    public function createCoupon(Request $request)
    {
        if (!isset($request->zone_name)) {
            return $this->ReturnResponse(false, "Champ Hotspot requis", [], 400);
        }
        if (!isset($request->subscription_name)) {
            return $this->ReturnResponse(false, "Champ offre requis", [], 400);
        }
        $data = array(
            "zone_name" => $request->zone_name,
            "subscription_name" => $request->subscription_name,
            "customer_fisrtname" => $request->subscription_name,
            "customer_mobile_number" => $request->subscription_name,
            "customer_mobile_number_code" => $request->subscription_name,
            "customer_notification" => 1,
            "customer_notification_lang" => "fr_FR",
        );
        $url = env('HOTPOST_URL');
        $headers = array(
            "Content-Type: application/json"
        );
        $uri = $url . '/subscription?zone_name=' . $request->zone_name;
        $statusCode = null;
        $isOk = false;
        $result = CommonService::wsPost($uri, $data, $headers, $statusCode, $isOk);
        if ($statusCode != 200) {
            return $this->ReturnResponse(false, "Impossible de créer le coupon", [$result], $statusCode);
        }
        $result = json_decode($result);
        return $this->ReturnResponse(true, "Coupon crée avec succès", [$result], 200);
    }
}
